/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer.sid;

import emulator.analyzer.Machine;
import emulator.analyzer.sid.SidImage;
import emulator.analyzer.sid.SidInfo;
import emulator.analyzer.util.RangeRelocation;
import emulator.analyzer.util.StatConverter;
import emulator.hardware.HwWord;
import emulator.util.AddressRange;
import emulator.util.AddressRangeList;
import emulator.util.file.FileHelper;
import emulator.util.file.FileInfo;
import emulator.util.file.FileLoadStrategy;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SidProcessor {
    static Logger logger = LogManager.getLogger((String)SidProcessor.class.getName());
    private static final int max_zp_bytes = 32;
    private Machine machine = new Machine();
    private String sid_name;
    private SidInfo sid_info = null;
    private int max_play_time = 18000;
    private int zp_count;
    private boolean is_stereo;
    private int code_count;
    private AddressRangeList unknown_list;
    private byte[] sid_data;
    private AddressRangeList zp_list = null;
    private PrintStream out;
    static final AddressRange ADDR_RANGE_ZP = new AddressRange(0, 255);
    static final AddressRange ADDR_RANGE_STACK = new AddressRange(256, 511);
    static final AddressRange ADDR_RANGE_SID1 = new AddressRange(54272, 54303);
    static final AddressRange ADDR_RANGE_SID2 = new AddressRange(54336, 54367);

    public SidProcessor(String sid_name) {
        this.sid_name = sid_name;
        this.machine.start();
    }

    public SidProcessor(String sid_file_name, PrintStream out) {
        this.sid_name = sid_file_name;
        this.out = out;
        this.machine.start();
    }

    public boolean processSid(int first_song, int last_song, boolean verbose) {
        this.sid_info = this.loadSid();
        if (this.isValid()) {
            return this.analzeSid(first_song, last_song, verbose);
        }
        return false;
    }

    public boolean isValid() {
        return this.sid_info != null;
    }

    public void printResult(PrintStream out) {
        out.println("Execution: " + this.machine.getCycles() + " cycles / " + this.machine.getTime() + " (PAL)");
        out.println("------------------------------------------------------------");
        out.println("File: " + this.sid_name);
        this.sid_info.print(out);
        out.println("------------------------------------------------------------");
        this.machine.dumpMemoryStats(out);
        out.println("------------------------------------------------------------");
        out.println("ZP usage: " + this.zp_count + " bytes");
        int code_size = this.sid_info.getBlockSize();
        if (this.machine.getDynArea() != null) {
            out.println("Dynamic code area: " + this.machine.getDynArea());
            code_size += this.machine.getDynArea().getWidth();
        }
        out.println("Code coverage: " + this.code_count + "/" + code_size + " (" + this.code_count * 100 / code_size + "%)");
        out.println("Stereo SID detected: " + (this.is_stereo ? "yes" : "no"));
        out.println("Unidentified memory access:");
        this.unknown_list.dump(out, " ");
        out.println("------------------------------------------------------------");
        out.println("SID Analysis complete.");
    }

    public SidInfo loadSid() {
        FileInfo info = FileHelper.getFileInfo(this.sid_name, FileHelper.guessFileFormat(this.sid_name));
        if (info == null) {
            logger.error("Unknown file format or file \"" + this.sid_name + "\" not found.");
            return null;
        }
        if (info.getStartAddress() < 0) {
            logger.error("Unknown load address for file \"" + this.sid_name + "\"");
            return null;
        }
        FileLoadStrategy loader = info.getLoadStrategy();
        if (loader == null) {
            logger.error("Unsupported file format for file \"" + this.sid_name + "\"");
            return null;
        }
        loader.loadToMemory(this.sid_name, this.machine.getMemory(), info.getStartAddress(), info.getBlockSize());
        this.sid_data = Arrays.copyOfRange(this.machine.getMemory().getData(), info.getStartAddress(), info.getStartAddress() + info.getBlockSize());
        return new SidInfo(info);
    }

    /*
     * Unable to fully structure code
     */
    private boolean analzeSid(int first_song, int last_song, boolean verbose) {
        result = false;
        this.machine.init(this.sid_info.getCodeRange(), this.out);
        song = first_song;
        while (song <= last_song && song <= this.sid_info.getSongCount()) {
            block9: {
                block10: {
                    block8: {
                        this.machine.getMemory().getData()[678] = 1;
                        if (verbose) {
                            this.out.println("Analyzing song " + song + "/" + this.sid_info.getSongCount() + " ...");
                        }
                        if (this.machine.analyzeSubroutine(this.sid_info.getInitAddress(), song, 0, 0)) break block8;
                        this.out.println("-> INIT failed!");
                        break block9;
                    }
                    if (this.sid_info.getCodeRange().contains(this.sid_info.getExecAddress())) ** GOTO lbl-1000
                    if (this.machine.getDynArea() == null) break block10;
                    if (this.machine.getDynArea().contains(this.sid_info.getExecAddress())) ** GOTO lbl-1000
                    this.out.println("Invalid EXEC address " + new HwWord((long)this.sid_info.getExecAddress()));
                    break block9;
                }
                if (!this.machine.activateArea(this.sid_info.getExecAddress())) {
                    this.out.println("Can not activate EXEC address " + new HwWord((long)this.sid_info.getExecAddress()));
                } else lbl-1000:
                // 3 sources

                {
                    cycle = 0;
                    while (cycle < this.max_play_time) {
                        if (!this.machine.analyzeSubroutine(this.sid_info.getExecAddress(), 0, 0, 0)) {
                            this.out.println("-> EXEC failed for cycle " + cycle + "!");
                            break;
                        }
                        ++cycle;
                    }
                    result = true;
                }
            }
            ++song;
        }
        access_field = this.machine.getAccessField();
        memory_size = access_field.length;
        zp_mask = StatConverter.rangeToMask(SidProcessor.ADDR_RANGE_ZP, memory_size);
        stack_mask = StatConverter.rangeToMask(SidProcessor.ADDR_RANGE_STACK, memory_size);
        sid1_mask = StatConverter.rangeToMask(SidProcessor.ADDR_RANGE_SID1, memory_size);
        sid2_mask = StatConverter.rangeToMask(SidProcessor.ADDR_RANGE_SID2, memory_size);
        code_mask = StatConverter.rangeToMask(this.sid_info.getCodeRange(), memory_size);
        dyn_range = this.machine.getDynArea();
        if (dyn_range != null) {
            code_mask = StatConverter.or(code_mask, StatConverter.rangeToMask(dyn_range, memory_size));
        }
        this.zp_count = StatConverter.count(StatConverter.and(access_field, zp_mask));
        this.is_stereo = StatConverter.count(StatConverter.and(access_field, sid2_mask)) > 0;
        this.code_count = StatConverter.count(StatConverter.and(access_field, code_mask));
        if (this.zp_count > 0) {
            this.zp_list = new AddressRangeList(StatConverter.and(access_field, zp_mask));
        }
        known_mask = StatConverter.or(StatConverter.or(StatConverter.or(zp_mask, stack_mask), StatConverter.or(sid1_mask, sid2_mask)), code_mask);
        this.unknown_list = new AddressRangeList(StatConverter.and(access_field, StatConverter.not(known_mask)));
        return result;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public SidImage getSidAt(int new_base_address, int new_zp_base, int new_sid_base, int new_hwid) {
        new_base_address = this.alignAddress(new_base_address, this.sid_info.getStartAddress());
        SidImage sid_image = new SidImage(this.sid_info);
        LinkedList<RangeRelocation> relocations = new LinkedList<RangeRelocation>();
        if (this.zp_list != null) {
            this.zp_list.toRelocations(relocations, new_zp_base);
        }
        relocations.add(new RangeRelocation(ADDR_RANGE_SID1, new_sid_base - ADDR_RANGE_SID1.getStart()));
        relocations.add(new RangeRelocation(new AddressRange(678, 678), new_hwid - 678));
        RangeRelocation dyn_relocation = null;
        if (this.machine.getDynArea() != null) {
            int new_dyn_start = this.alignAddress(new_base_address + this.sid_info.getBlockSize(), this.machine.getDynArea().getStart());
            dyn_relocation = new RangeRelocation(this.machine.getDynArea(), new_dyn_start - this.machine.getDynArea().getStart());
        }
        sid_image.relink(this.machine.getAddressMap(), this.sid_data, new RangeRelocation(this.sid_info.getCodeRange(), new_base_address - this.sid_info.getStartAddress()), dyn_relocation, this.machine.getDynFlow(), relocations, this.machine.getCmpCommands());
        return sid_image;
    }

    private int alignAddress(int address, int align_target) {
        if ((address & 0xFF) != (align_target & 0xFF)) {
            address += align_target - address & 0xFF;
        }
        return address;
    }

    public boolean isConvertiblePrinting(PrintStream out) {
        if (this.zp_count > 32) {
            out.println("Too many ZP allocations (" + this.zp_count + "/" + 32 + ").");
            return false;
        }
        if (this.is_stereo) {
            out.println("Stereo SID not supported.");
            return false;
        }
        if (!this.unknown_list.isEmpty()) {
            out.println("Unidentified memory access:");
            this.unknown_list.dump(out, " ");
            return false;
        }
        return true;
    }
}

